<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // altering Users Table
        Schema::create('pages', function(Blueprint $table){
            $table->id();
            $table->string('title');
            $table->string('slug')->unique;
            $table->longText('content')->nullable();
            $table->boolean('status')->default(false);  // 0 = inactive, 1 = active

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pages');
    }
};
